package com.adobe.cq.commerce.pim.api;

/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.Product;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

/**
 * Decorates a list of {@link Product} objects with data obtained from other sources
 */
@ConsumerType
public interface ProductListDecorator {

    /**
     * Processes a list of {@link Product} objects, adding data from other sources to the standard product data
     * @param request a {@link SlingHttpServletRequest} (authenticated)
     * @param response a {@link SlingHttpServletResponse}
     * @param products the list of products
     * @return a list of {@link Map} objects that represent the product data
     */
    public List<Map<String, Object>> process(SlingHttpServletRequest request, SlingHttpServletResponse response, List<Product> products);

}
