/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.pim.api;

import aQute.bnd.annotation.ConsumerType;

import java.util.Map;

@ConsumerType
public interface ProductServicesManager {

    /**
     * Return a map of registered {@link ProductImporter}s, keyed by importer name.
     *
     * By convention, the importer's name is normally the commerce provider's name,
     * although this is not a hard requirement.  Commerce providers which need to support
     * multiple importers are encouraged to use the commerce provider name as a prefix.
     */
    public Map<String, ProductImporter> getProductImporters();

    /**
     * Return a map of registered {@link CatalogBlueprintImporter}s, keyed by importer name.
     *
     * By convention, the importer's name is normally the commerce provider's name,
     * although this is not a hard requirement.  Commerce providers which need to support
     * multiple importers are encouraged to use the commerce provider name as a prefix.
     */
    public Map<String, CatalogBlueprintImporter> getBlueprintImporters();
}
