/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import java.util.Iterator;

/**
 * Implementors provide easier access to DAM collections for managing the associated
 * content of a content fragment.
 */
@ProviderType
public interface CollectionHelper {

    /**
     * Gets an iterator on all collections that can be added to a content fragment as
     * "associated content".
     *
     * <p>In this context, the term "collections" refers to DAM or other resource
     * collections (technically implemented as Sling Resource Collections, see
     * {@link org.apache.sling.resource.collection.ResourceCollection}).</p>
     *
     * <p>As some of the implementations use a "smart collection" approach (like a
     * collection containing the dynamically updated list of last modified items), which
     * you may or may not want included in your list, there's a parameter for defining
     * if such smart collections should actually be included.</p>
     *
     * @param resolver The  {@link ResourceResolver} for retrieving the collections
     * @param includeSmartCollections True if smart collections should be included
     * @return The iterator on collections; resource type of each resource type is
     *         <code>sling/collection</code>
     */
    Iterator<Resource> getCollections(ResourceResolver resolver,
                                      boolean includeSmartCollections);

}
