/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

/**
 * <p>Implementations of this interface allow to access an element template through a
 * well-defined API, without needing to care about the underlying content structure.</p>
 */
@ProviderType
public interface ElementTemplate {

    /**
     * Gets the (technical) name of the represented content element.
     *
     * @return The name
     */
    String getName();

    /**
     * Gets the (human-readable) title of the represented content element.
     *
     * @return The title
     */
    String getTitle();

    /**
     * Gets the initial MIME type of the variation.
     *
     * <p>This method must return a MIME type that is actually supported by the
     * implementation.</p>
     *
     * @return The initial MIME type
     */
    String getInitialContentType();

    /**
     * <p>Gets the content type of the default content.</p>
     *
     * <p>If this method returns <code>null</code>, the implementation should consider this
     * as "undefined" rather than "empty". In such cases, it's the implementation's duty
     * to provide a sensible default content. Could (for example) be an empty string for
     * plain text content or <code>&lt;p>&amp;nbsp;&lt;/p></code> for HTML content.</p>
     *
     * @return The default content; if null, a sensible default content has to be provided
     *         by the implementation
     */
    String getDefaultContent();

}