/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.adapter.Adaptable;

import java.util.Iterator;

/**
 * <p>Implementations of this interface allow to access the fragment template in a
 * standardized way, independently of the actual content structure.</p>
 *
 * <p>Each content fragment carries a copy of the template it was created from, hence
 * it is independent from the original template (and from changes that happened there
 * after the fragment was created).</p>
 */
@ProviderType
public interface FragmentTemplate extends Adaptable {

    /**
     * Gets the title of the template.
     *
     * @return The title
     */
    String getTitle();

    /**
     * Gets a description for the template (if available).
     *
     * @return The description; empty string if none is available
     */
    String getDescription();

    /**
     * Gets an iterator on the templates for predefined elements.
     *
     * @return Iterator on element templates
     */
    Iterator<ElementTemplate> getElements();

    /**
     * Gets the template for the specified content element.
     *
     * @param element The content element
     * @return The element template; <code>null</code> if there is no template for the
     *         specified element
     */
    ElementTemplate getForElement(ContentElement element);

    /**
     * Gets an iterator on the templates of predefined global variations.
     *
     * @return Iterator on variation templates
     */
    Iterator<VariationTemplate> getVariations();

    /**
     * Gets the template for the specified global content variation.
     *
     * @param variation The content variation
     * @return The variation template; <code>null</code> if there is no template for the
     *         specified variation
     */
    VariationTemplate getForVariation(ContentVariation variation);

    /**
     * Gets an iterator on the initial references that form the associated content of the
     * fragment.
     *
     * @return Iterator on the initial associated content
     */
    Iterator<String> getInitialAssociatedContent();

    /**
     * Gets the meta data definition.
     *
     * @return The meta data definition
     */
    MetaDataDefinition getMetaDataDefinition();

}
