package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

import java.util.Iterator;

/**
 * Implementations of this class provide access to the meta data definition of a template.
 */
@ProviderType
public interface MetaDataDefinition {

    /**
     * Gets an iterator on the meta data properties that are available.
     *
     * @return Iterator on meta data properties
     */
    Iterator<MetaDataProperty> getMetaDataProperties();

    /**
     * Gets a meta data property by the specified name.
     *
     * @param name The name of the meta data property
     * @return The meta data property; <code>null</code> if no such property exists
     */
    MetaDataProperty getMetaDataPropertyByName(String name);

}
