package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

import java.util.Iterator;

/**
 * Implementations of this class represent a single meta data definition.
 */
@ProviderType
public interface MetaDataProperty {

    /**
     * Gets the (technical) name of the meta data property.
     *
     * @return The name
     */
    String getName();

    /**
     * Gets the (human-readable) title of the meta data property.
     *
     * @return The title
     */
    String getTitle();

    /**
     * Gets the type of the meta data property.
     *
     * @return The type of meta data
     */
    String getType();

    /**
     * Gets a config property of the meta data property.
     *
     * <p>Available properties are dependant on the type of the meta data.</p>
     *
     * @param name The name of the config property
     * @return The value of the config property
     */
    Object getConfig(String name);

    /**
     * Gets an iterator on the names of the config properties that are available.
     *
     * @return Iterator on config proeprties names
     */
    Iterator<String> getConfigNames();

}
