/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

/**
 * Implementors provide some essential definitions of a variation.
 */
@ProviderType
public interface VariationDef {

    /**
     * Gets the (technical) name of the variation.
     *
     * <p>This can be used as an identifier.</p>
     *
     * @return The name of the variation
     */
    String getName();

    /**
     * Gets the (human-readable) title of the variation.
     *
     * @return The title of the variation
     */
    String getTitle();

    /**
     * Gets the description of the variation.
     *
     * @return The description of the variation
     */
    String getDescription();

}
