/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

/**
 * Implementations of this interface allow accessing a variation template in a standardized
 * way, without requiring knowledge about the underlying content structure.
 */
@ProviderType
public interface VariationTemplate {

    /**
     * Gets the (technical) name of the variation template.
     *
     * @return The name
     */
    String getName();

    /**
     * Gets the (human-readable) title of the variation template.
     *
     * @return The title
     */
    String getTitle();

    /**
     * Gets the (human-readable) description of the variation template
     *
     * @return The (human-readable) description of the variation
     */
    String getDescription();

}
