/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

import java.util.Iterator;

/**
 * Implementations of this interface provide means to version their content.
 */
@ProviderType
public interface Versionable {

    /**
     * Creates a new version of the implementing element.
     *
     * <p>Transactional behavior: All previous changes to the entire content fragment need
     * to be committed before this method is called. The method will also commit all
     * required changes, so the caller does not have to explicitly commit the respective
     * {@link org.apache.sling.api.resource.ResourceResolver}.</p>
     *
     * @param label The label
     * @param comment A comment
     * @return Definition of the newly created version
     * @throws ContentFragmentException if the element could not be versioned
     * @throws IllegalStateException if the required transactional prerequisites are not
     *                               met, for example if the respective
     *                               {@link org.apache.sling.api.resource.ResourceResolver}
     *                               has pending/uncommitted changes
     */
    VersionDef createVersion(String label, String comment) throws ContentFragmentException;

    /**
     * <p>Creates an iterator on the versions that are available for the implementing
     * element.</p>
     *
     * <p>The list does not contain the "current" version of the element itself, only
     * archived versions.</p>
     *
     * @return Iterator on available versions
     * @throws ContentFragmentException if the version history could not be created
     */
    Iterator<VersionDef> listVersions() throws ContentFragmentException;

    /**
     * <p>Gets the content of the version of the implementing element that is specified
     * by the provided {@link VersionDef}.</p>
     *
     * <p>The {@link VersionDef} should match one of those returned by
     * {@link #listVersions()}.</p>
     *
     * @param version The version definition
     * @return The versioned content
     * @throws ContentFragmentException if the version content could not be determined or an
     *                                  invalid version definition was provided
     */
    VersionedContent getVersionedContent(VersionDef version)
            throws ContentFragmentException;

}
