/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

/**
 * Represents the content of a specific version of a content item (be it the element master
 * or a variation of it).
 */
@ProviderType
public interface VersionedContent {

    /**
     * Gets the content type of the versioned content.
     *
     * @return The content type of the versioned content
     */
    String getContentType();

    /**
     * Gets the content as a <code>String</code>.
     *
     * @return The content (as a <code>String</code>)
     */
    String getContent();

}
