//******************************************************************************
// ADOBE CONFIDENTIAL
// ___________________
//
//  Copyright 2015 Adobe Systems Incorporated
//  All Rights Reserved.
//
// NOTICE:  All information contained herein is, and remains
// the property of Adobe Systems Incorporated and its suppliers,
// if any.  The intellectual and technical concepts contained
// herein are proprietary to Adobe Systems Incorporated and its
// suppliers and may be covered by U.S. and Foreign Patents,
// patents in process, and are protected by trade secret or copyright law.
// Dissemination of this information or reproduction of this material
// is strictly forbidden unless prior written permission is obtained
// from Adobe Systems Incorporated.
//******************************************************************************

package com.adobe.cq.dam.dm.delivery.api;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.dam.dm.process.api.PTiffRendition;
import com.day.cq.dam.api.Asset;

/**
 * Helper service providing information of
 * image delivery state and configuration.
 */
@ProviderType
public interface ImageDelivery {

    /**
     * Is dynamic imaging feature avalable.
     * @return <code>true</code> if dynamicimaging runmode
     * is active <code>false</code> otherwise
     */
    boolean isEnabled();

    /**
     * Find the PTIFF rendition for the given asset.
     *
     * @param asset Asset instance
     * @return PTIFF rendition or null if not available
     */
    PTiffRendition getPTiffRendition(Asset asset);

}
