/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.dam.dm.icc.api;

import java.util.*;

public class ICCProfileList {

    private final List<ICCProfile> iccProfileList;
    private final String defaultRGBProfile;
    private final String defaultCMYKProfile;

    public ICCProfileList(List<ICCProfile> iccProfileList, String defaultRGBProfile, String defaultCMYKProfile) {
        this.iccProfileList = Collections.unmodifiableList(new ArrayList<ICCProfile>(iccProfileList));
        this.defaultRGBProfile = defaultRGBProfile;
        this.defaultCMYKProfile = defaultCMYKProfile;
    }

    public List<ICCProfile> getIccProfileList() {
        return iccProfileList;
    }

    public String getDefaultRGBProfile() {
        return defaultRGBProfile;
    }

    public String getDefaultCMYKProfile() {
        return defaultCMYKProfile;
    }

    public Map<String, String> getListAsMap() {
        Map<String, String> list = new HashMap<String, String>();
        for (ICCProfile iccProfile : iccProfileList) {
            list.put(iccProfile.getName(), iccProfile.getColorSpace());
        }
        return list;
    }

}
