/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.dam.dm.process.api;

import aQute.bnd.annotation.ProviderType;

import java.io.File;

/**
 * Access to the PTIFF file cache entry
 */
@ProviderType
public interface PTiffFileAccess {

    /**
     * Retrieve file from cache entry payload (may be null)
     */
    File getFile();

    /**
     * Modify payload. Might be null to clear payload.
     */
    void setFile(File file);

    /**
     * Release access to entry. Allows someone else to access it.
     */
    void release();

}

