/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.dam.dm.process.api;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.dam.api.Asset;

/**
 * PTIFF file cache
 */
@ProviderType
public interface PTiffFileCache {

    /**
     * Lookup the PTIFF file associated with the asset in the cache. As long as the PTiffFileAccess
     * reference is not release, other callers are blocked from accessing this entry.
     *
     * @param asset Valid asset to find the PTIFF file reference for
     * @return Accessor to access cache entry, always not-null may have an empty payload
     */
    PTiffFileAccess lookup(Asset asset);

}
