/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.dam.dm.process.api;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.ValueMap;

/**
 * Dynamic Media PTIFF rendition metadata
 */
@ProviderType
public interface PTiffMetadata {

    /**
     * True if PTIFF rendition was generated from the original asset rendition (Mandatory)
     */
    String PTIFF_ORIGINAL = "ptiff.original";

    /**
     * Width of the PTIFF rendition in pixels (Mandatory)
     */
    String PTIFF_WIDTH = "ptiff.width";

    /**
     * Height of the PTIFF rendition in pixels (Mandatory)
     */
    String PTIFF_HEIGHT = "ptiff.height";

    /**
     * Size of the PTIFF after ingestion. Used for data validation (Optional)
     */
    String PTIFF_SIZE = "ptiff.size";

    /**
     * MD5 digest of the PTIFF content. Used for data validation (Optional)
     */
    String PTIFF_MD5 = "ptiff.md5";

    /**
     * Retrieve any warnings that may have occurred during processing (optional)
     */
    String PTIFF_WARNINGS = "ptiff.warnings";

    /**
     * @return True if PTIFF rendition was generated from the original asset rendition.
     */
    boolean isOriginal();

    /**
     * Check if this PTIFF rendition has a defined width and height.
     * This is the case for older Dynamic Media video assets.
     *
     * @return True if PTIFF rendition has a defined width and height.
     */
    boolean hasSize();

    /**
     * Width of the PTIFF rendition in pixels
     * @return width in pixels
     */
    int getWidth();

    /**
     * Height of the PTIFF rendition in pixels
     * @return height in pixels
     */
    int getHeight();

    /**
     * Retrieve the entire metadata map
     * @return entire metadata map
     */
    ValueMap getProps();

}
