/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.dam.index.builder;

import com.adobe.cq.dam.index.builder.api.PropertyDefinition;
import com.google.common.collect.ImmutableMap;
import org.apache.jackrabbit.JcrConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import java.util.HashMap;
import java.util.List;

/**
 * This class represents IndexRule for Oak Lucene Index
 */
public class IndexRule {
    String primaryType;
    List<? extends PropertyDefinition> propertyDefinitions;


    public IndexRule(String primaryType, List<? extends PropertyDefinition> propDef) {
        this.primaryType = primaryType;
        this.propertyDefinitions = propDef;
    }

    /**
     * @return return <code>primaryType</code> for <code>IndexRule</code>
     */
    public String primaryType() {
        return primaryType;
    }

    /**
     * @return <code>PropertyDefinition</code> for <code>IndexRule</code>
     */
    public List<? extends PropertyDefinition> propertyDefinition() {
        return propertyDefinitions;
    }

    /**
     * Creates <code>IndexRule</code> under given resource
     *
     * @throws PersistenceException
     */
    public void build(Resource resource) throws PersistenceException {
        ResourceResolver resolver = resource.getResourceResolver();

        Resource primaryTypeNode = resolver.create(resource, primaryType, new HashMap<String, Object>());
        Resource propertiesNode = resolver.create(primaryTypeNode, LuceneIndexConstants.PROP_NODE,
                ImmutableMap.of(JcrConstants.JCR_PRIMARYTYPE, (Object) "nt:unstructured"));

        for (PropertyDefinition propDef : propertyDefinitions) {
            propDef.build(propertiesNode);
        }
    }
}
