/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.dam.index.builder.api;

import org.apache.sling.api.resource.Resource;

/**
 * A <code>IndexDefinition</code> represents a jackrabbit-oak Index Definition
 */
public interface IndexDefinition {

    /**
     * Creates the IndexDefinition under given resource
     *
     * @param resource Resource under which the IndexDefinition is to be
     *                 created
     */
    boolean build(Resource resource);

    /**
     * Creates the IndexDefinition under given resource and initiates indexing
     * process
     *
     * @param resource Resource under which the IndexDefinition is to be
     *                 created
     * @param reindex  Triggers re-indexing process
     */
    boolean build(Resource resource, boolean reindex);
}
