/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.deserfw.api;

import javax.annotation.Nullable;

public interface AttachAPIResolver {
    
    /**
     * Provides a service for obtaining the Java Attach API Virtual Machine class as defined by 
     * https://docs.oracle.com/javase/6/docs/jdk/api/attach/spec/com/sun/tools/attach/VirtualMachine.html
     * 
     * The Class returned is generally from the system classloader.
     * 
     * Multiple AttachAPIs will be tried in order of service priority.
     * 
     * While bundles may load and unload dynamically, this service must be available at the time this bundle is loaded
     * as agent association happens immediately upon application start and cannot be undone or retried at a later time.
     * 
     * These services will only be used if the associated agent is not provided via java command line argument.
     * 
     * @Return the Class that represents VirtualMachine class and associated methods, or null to indicate 
     * this AttachAPIResolver cannot handle the request for this JVM.
     */
    @Nullable
    public Class<?> getAttachAPIClass();
}
