/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.history.api;

import java.util.Calendar;
import java.util.Set;

public interface HistoryEntry extends Comparable<HistoryEntry> {

    String getResourcePath();

    Set<String> getResourceTypes();

    Action getAction();

    Calendar getDate();

    String getUserId();

    public enum Action {
        /**
         * Access the resource
         */
        VIEW,
        /**
         * Create, edit or delete the resource
         */
        EDIT
    }

}
