/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.history.filter;

import com.adobe.cq.history.api.HistoryEntry;
import com.day.cq.commons.Filter;

import java.util.Collection;
import java.util.HashSet;

public class ResourceTypesFilter implements Filter<HistoryEntry> {

    private Collection<String> filteredResourceTypes = new HashSet<String>();

    public ResourceTypesFilter(Collection<String> filteredResourceTypes) {
        this.filteredResourceTypes.addAll(filteredResourceTypes);
    }

    public boolean includes(HistoryEntry historyEntry) {
        for (String resourceType : historyEntry.getResourceTypes()) {
            if (filteredResourceTypes.contains(resourceType)) {
                return true;
            }
        }

        return filteredResourceTypes.isEmpty();
    }

}
