package com.adobe.cq.mcm.campaign;

import com.day.cq.mcm.campaign.CampaignCredentials;
import com.day.cq.mcm.campaign.CampaignException;
import com.day.cq.wcm.webservicesupport.Configuration;
import org.apache.sling.api.resource.Resource;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * <p>Provides means to proxy requests to Adobe Campaign.</p>
 *
 * <p>Should be used by servlet implementations that simply forward requests to Adobe
 * Campaign and transfer the result of the request back to the client.</p>
 */
public interface CampaignProxy {

    /**
     * <p>Proxies a GET request to the specified Campaign method.</p>
     *
     * @param remoteFunction The remote function (including AC namespace + extension)
     * @param params The URL parameters
     * @param credentials The credentials for accessing the Campaign instance
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void get(String remoteFunction, Map<String, String> params,
             CampaignCredentials credentials, HttpServletResponse response)
            throws CampaignException;

    /**
     * <p>Proxies a GET request to the specified Campaign method.</p>
     *
     * @param remoteFunction The remote function (including AC namespace + extension)
     * @param params The URL parameters
     * @param resource The resource the request is addressing (for retrieving credentials
     *                 for accessing the Campaign instance)
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void get(String remoteFunction, Map<String, String> params, Resource resource,
             HttpServletResponse response) throws CampaignException;

    /**
     * <p>Proxies a GET request to the specified Campaign method.</p>
     *
     * @param remoteFunction The remote function (including AC namespace + extension)
     * @param params The URL parameters
     * @param config The cloud service configuration to be used (for retrieving credentials
     *                 for accessing the Campaign instance)
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void get(String remoteFunction, Map<String, String> params, Configuration config,
             HttpServletResponse response) throws CampaignException;

    /**
     * <p>Proxies a POST request to the specified Campaign method.</p>
     *
     * @param remoteFunction The remote function (including AC namespace + extension)
     * @param postData Post data
     * @param credentials The credentials for accessing the Campaign instance
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void post(String remoteFunction, Map<String, String> postData,
              CampaignCredentials credentials, HttpServletResponse response)
            throws CampaignException;

    /**
     * <p>Proxies a POST request to the specified Campaign method.</p>
     *
     * @param remoteFunction The remote function (including AC namespace + extension)
     * @param postData Post data
     * @param resource The resource the request is addressing (for retrieving credentials
     *                 for accessing the Campaign instance)
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void post(String remoteFunction, Map<String, String> postData, Resource resource,
              HttpServletResponse response)
            throws CampaignException;

    /**
     * <p>Proxies a POST request to the specified Campaign method.</p>
     *
     * @param remoteFunction The remote function (including AC namespace + extension)
     * @param postData Post data
     * @param config The cloud service configuration to be used (for retrieving credentials
     *                 for accessing the Campaign instance)
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void post(String remoteFunction, Map<String, String> postData,
              Configuration config, HttpServletResponse response)
            throws CampaignException;

    /**
     * <p>Proxies a GET request with Basic authentication to the specified Campaign
      * method.</p>
      *
      * <p>This is required for the query API in ".next style".</p>
     *
     * @param url The remote function (including AC namespace + extension)
     * @param credentials The credentials for accessing the Campaign instance
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void getWithBasicAuth(String url, CampaignCredentials credentials,
                          HttpServletResponse response) throws CampaignException;

     /**
     * <p>Proxies a GET request with Basic authentication to the specified Campaign
      * method.</p>
      *
      * <p>This is required for the query API in ".next style".</p>
     *
     * @param url The remote function (including AC namespace + extension)
     * @param resource The resource the request is addressing (for retrieving credentials
     *                 for accessing the Campaign instance)
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void getWithBasicAuth(String url, Resource resource, HttpServletResponse response)
                throws CampaignException;

     /**
     * <p>Proxies a GET request with Basic authentication to the specified Campaign
      * method.</p>
      *
      * <p>This is required for the query API in ".next style".</p>
     *
     * @param url The remote function (including AC namespace + extension)
     * @param config The cloud service configuration to be used (for retrieving credentials
     *                 for accessing the Campaign instance)
     * @param response The response
     * @throws CampaignException if the request could not be proxied
     */
    void getWithBasicAuth(String url, Configuration config,
                          HttpServletResponse response) throws CampaignException;

}
