/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mcm.salesforce;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * The <code>SalesforceConfiguration</code> contains the mapping the attributes of an AEM user to that of a Salesforce
 * Lead.
 * */
@Component(label = "%sf.configuration.name", description = "%sf.configuration.description", metatype = true)
@Service(value=SalesforceConfiguration.class)
public class SalesforceConfiguration {

    private static final String DEFAULT_FIRSTNAME_MAPPING = "givenName=FirstName";
    private static final String DEFAULT_TITLE_MAPPING = "title=Title";
    private static final String DEFAULT_LASTNAME_MAPPING = "familyName=LastName";
    private static final String DEFAULT_EMAIL_MAPPING = "email=Email";
    private static final String DEFAULT_COMPANY_MAPPING = "company=Company";
    private static final String DEFAULT_PHONE_MAPPING = "phoneNumber=Phone";
    private static final String DEFAULT_MOBILE_MAPPING = "mobile=MobilePhone";
    private static final String DEFAULT_FAX_MAPPING = "fax=Fax";
    private static final String DEFAULT_WEBSITE_MAPPING = "website=Website";
    private static final String DEFAULT_LEAD_SOURCE_MAPPING = "source=LeadSource";
    private static final String DEFAULT_ANNUAL_REVENUE_MAPPING = "annualRevenue=AnnualRevenue";
    private static final String DEFAULT_STATUS_MAPPING = "status=Status";
    private static final String DEFAULT_RATING_MAPPING = "rating=Rating";
    private static final String DEFAULT_COUNT_EMP_MAPPING = "numberOfEmployees=NumberOfEmployees";
    private static final String DEFAULT_PROD_INTEREST_MAPPING = "productInterest=ProductInterest__c";
    private static final String DEFAULT_POSTALCODE_MAPPING = "postalCode=PostalCode";
    private static final String DEFAULT_CITY_MAPPING = "city=City";
    private static final String DEFAULT_STREET_MAPPING = "street=Street";
    private static final String DEFAULT_STATE_MAPPING = "state=State";
    private static final String DEFAULT_COUNTRY_MAPPING = "country=Country";
    private static final String DEFAULT_INDUSTRY_MAPPING = "industry=Industry";

    @Property(value = {DEFAULT_FIRSTNAME_MAPPING, DEFAULT_TITLE_MAPPING, DEFAULT_LASTNAME_MAPPING,
            DEFAULT_EMAIL_MAPPING, DEFAULT_COMPANY_MAPPING, DEFAULT_PHONE_MAPPING, DEFAULT_MOBILE_MAPPING,
            DEFAULT_FAX_MAPPING, DEFAULT_WEBSITE_MAPPING, DEFAULT_LEAD_SOURCE_MAPPING, DEFAULT_ANNUAL_REVENUE_MAPPING,
            DEFAULT_STATE_MAPPING, DEFAULT_STATUS_MAPPING, DEFAULT_RATING_MAPPING, DEFAULT_COUNT_EMP_MAPPING,
            DEFAULT_PROD_INTEREST_MAPPING, DEFAULT_POSTALCODE_MAPPING, DEFAULT_CITY_MAPPING, DEFAULT_STREET_MAPPING,
            DEFAULT_COUNTRY_MAPPING, DEFAULT_INDUSTRY_MAPPING})
    private static final String DEFAULT_LEAD_MAPPING = "sf.lead.mapping";

    private Map<String,String> leadsMapping = new HashMap<String, String>();

    private static final Logger log = LoggerFactory.getLogger(SalesforceConfiguration.class);

    @Activate
    protected void activate(ComponentContext context){

        try {
            String[] mappings = OsgiUtil.toStringArray(context.getProperties().get(DEFAULT_LEAD_MAPPING));
            if(mappings!=null){
                for(int i=0; i<mappings.length; i++){
                    String[] map = mappings[i].split("=");
                    leadsMapping.put(map[0], map[1]);
                }
            }
        } catch (Exception e) {
            log.error("Unable to Parse Salesforce Configuration. Exception: "+e.getMessage());
        }
    }

    /**
     * Returns the mapping of attributes of an AEM user with that of a Salesforce Lead
     * */
    public Map<String,String> getLeadsMapping(){
        return leadsMapping;
    }


}
