/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mcm.salesforce;

import java.lang.Exception;

/**
 * The <code>SalesforceException</code> is a custom exception wrapping the exception message and the code used
 * internally to distinguish between various exceptions that might be thrown from Salesforce.
 * */
public class SalesforceException extends Exception {

    static final long serialVersionUID = 548754621;

    static final Long INVALID_SEARCH_QUERY_PARAMS = 1L;

    private Long exceptionCode;

    public SalesforceException(String message, Long code){
        super(message);
        exceptionCode = code;
    }

    public SalesforceException(String message) {
        super(message);
    }

    public SalesforceException(Throwable cause) {
        super(cause);
    }

    public SalesforceException(String message, Throwable cause) {
        super(message, cause);
    }

    public Long getExceptionCode() {
        return exceptionCode;
    }

    public void setExceptionCode(Long exceptionCode) {
        this.exceptionCode = exceptionCode;
    }
}
