/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.mcm.salesforce;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/**
 * The <code>SalesforceResponse</code> is a wrapper over the data returned by Salesforce on executing any request to
 * Salesforce.
 * */
public class SalesforceResponse {

    private String body;
    private Integer code;
    private Boolean accessTokenUpdated = false;

    public SalesforceResponse(Integer code, String body) {
        super();
        this.body = body;
        this.code = code;
    }

    public SalesforceResponse() {
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Boolean getAccessTokenUpdated() {
        return accessTokenUpdated;
    }

    public void setAccessTokenUpdated(Boolean accessTokenUpdated) {
        this.accessTokenUpdated = accessTokenUpdated;
    }

    /**
     * Converts the JSON format returned from SF into an JSON Object.
     * Response can be a JSON Array or a normal JSON Object or it can be null
     * */
    public JSONObject getBodyAsJSON() throws JSONException{
        if(getBody()!=null){
            if(getBody().charAt(0)=='[' && getBody().charAt(getBody().length()-1)==']'){
                String responseBody = getBody().substring(1,getBody().length()-1);
                return new JSONObject(responseBody);
            }
            return new JSONObject(getBody());
        }
        return null;
    }
}
