/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.mcm.salesforce;

/**
 * The <code>SalesforceSearchParameters</code> is the helping object used for searching leads. It contains the search
 * value, the type of value searched and the comparison operator used via searching. Also contains the results
 * obtained after searching.
 */
public class SalesforceSearchParameters {

    public enum SalesforceObjectType{
        LEAD, CONTACT
    }

    private String searchOperator;
    private String searchVal;
    private String searchType;
    private String[] resultProperties;
    private SalesforceObjectType objectType;

    public SalesforceObjectType getObjectType() {
        return objectType;
    }

    public void setObjectType(SalesforceObjectType objectType) {
        this.objectType = objectType;
    }

    public void setObjectType(String objectType){
        if(SalesforceObjectType.LEAD.name().equalsIgnoreCase(objectType))
            this.objectType = SalesforceObjectType.LEAD;
        else if(SalesforceObjectType.CONTACT.name().equalsIgnoreCase(objectType))
            this.objectType = SalesforceObjectType.CONTACT;
    }

    public String getSearchOperator() {
        return searchOperator;
    }

    public void setSearchOperator(String searchOperator) {
        this.searchOperator = searchOperator;
    }

    public String getSearchVal() {
        return searchVal;
    }

    public void setSearchVal(String searchVal) {
        this.searchVal = searchVal;
    }

    public String getSearchType() {
        return searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String[] getResultProperties() {
        return resultProperties;
    }

    public void setResultProperties(String[] resultProperties) {
        this.resultProperties = resultProperties;
    }

}
