/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.mobile.dps;

import java.util.HashMap;
import java.util.Map;

/**
 * Enum of DPS AdType
 *
 */
public enum AdType {
    STATIC("static"),
    EFT("eft");

    /**
     * Enum map for lookup
     */
    private static Map<String, AdType> ENUM_BY_VALUE;

    /**
     * Used to map the property name to the enum value
     */
    static {
        ENUM_BY_VALUE = new HashMap<String, AdType>(AdType.values().length);
        for (AdType enumValue : AdType.values()) {
            ENUM_BY_VALUE.put(enumValue.getValue(), enumValue);
        }
    }

    /**
     * The value for this enum
     */
    private String value;

    /**
     * Create an AdType
     *
     * @param value The property value
     */
    private AdType(String value) {
        this.value = value;
    }

    /**
     * @return AdType value
     */
    public String getValue() {
        return value;
    }

    /**
     * Returns true if this is a AdType and false otherwise.
     *
     * @param value The value to check
     * @return true if a AdType and false otherwise
     */
    public static final boolean isAdType(String value) {
        return ENUM_BY_VALUE.containsKey(value);
    }

    /**
     * Return the AdType object for the specified value
     *
     * @param value used to specify the AdType
     * @return an AdType for the specified value or null if invalid
     */
    public static final AdType getAdType(String value) {
        return ENUM_BY_VALUE.get(value);
    }
}
