/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mobile.dps;

import aQute.bnd.annotation.ProviderType;

/**
 * Domain object representing DPS Article metadata.
 *
 * @since 6.2
 */
@ProviderType
public interface DPSArticle extends DPSEntity {

    String getAuthor();

    String getAuthorURL();

    boolean isHiddenFromBrowsePage();

    boolean isTrustedContent();

    ProtectedAccess getAccess();

    boolean isAdvertisement();

    AdType getAdType();

    String getAdCategory();
    
    String getAdvertiser();

    // Social
    String getArticleText();

    String getSocialShareURL();

    String getWebArticleURL();

    String getSocialImagePath();
}
