/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mobile.dps;

import aQute.bnd.annotation.ProviderType;

import java.util.Date;
import java.util.Set;

/**
 * Domain object representing DPS Entity metadata.
 *
 * @since 6.2
 */
@ProviderType
public interface DPSEntity extends DPSObject {

    // ##########################
    // AEM only
    // ##########################

    DPSProject getProject();

    String getEntityName();

    Date getLastDPSUpload();

    String getLastDPSUploadBy();

    Date getLastDPSPublished();

    String getLastDPSPublishedBy();

    Date getLastDPSSynced();

    boolean isImported();

    // ##########################
    // DPS and AEM
    // ##########################

    String getShortTitle();

    String getAbstract();

    String getShortAbstract();

    String getDepartment();

    String getCategory();

    Set<String> getKeywords();

    Set<String> getInternalKeywords();

    Importance getImportance();

    String getImagePath();

    @Deprecated
    String getTOCImagePath();
}
