/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mobile.dps;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

import java.util.Date;

/**
 * Domain object representing base DPS object.
 *
 * @since 5.6
 */
@ProviderType
public interface DPSObject extends Adaptable {

    String getId();

    String getTitle();

    String getName();

    String getPath();

    String getDPSResourceType();

    Date getLastCQModified();

    String getLastCQModifiedBy();

    Date getCreated();

    String getCreatedBy();

    /**
     * Returns a JSON object of this object
     * @return a JSONObject
     */
    JSONObject toJSON() throws JSONException;

    String getProjectId();
}