/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mobile.dps;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.wcm.webservicesupport.Configuration;
import org.apache.sling.api.resource.Resource;

import java.util.Date;
import java.util.List;

/**
 * Defines a DPS Project
 *
 * @since 6.2
 */
@ProviderType
public interface DPSProject extends DPSObject {

    String getDescription();
    
       /**
     * Get all articles
     *
     * @return article list
     */
    List<DPSArticle> getArticles();

    /**
     * Get articles under a folder
     *
     * @return article list
     */
    List<DPSArticle> getArticles(Resource folder);

    /**
     * Get an article by its name
     * @return article if found, null otherwise
     */
    DPSArticle getArticle(String name);

    /**
     * Get all banners
     *
     * @return banner list
     */
    List<DPSBanner> getBanners();

    /**
     * Get banners under a folder
     *
     * @return banner list
     */
    List<DPSBanner> getBanners(Resource folder);

    /**
     * Get an banner by its name
     * @return banner if found, null otherwise
     */
    DPSBanner getBanner(String name);

    /**
     * Get all Collections
     *
     * @return Collection list
     */
    List<DPSCollection> getCollections();

    /**
     * Get all Collections under a folder
     *
     * @return Collection list
     */
    List<DPSCollection> getCollections(Resource folder);

    /**
     * Get an Collection by its name
     * @return Collection if found, null otherwise
     */
    DPSCollection getCollection(String name);

    /**
     * Returns the content sync template path.
     * @return the path to the export template.
     */
     String getExportTemplatePath();

    /**
     * Returns DPS Configuration
     * @return DPS Configuration if set, null otherwise
     * @throws DPSException 
     */
     Configuration getDPSConfiguration() throws DPSException;

    /**
     *
     * @return last time shared HTMLResources were uploaded, null if not uploaded
     */
     Date getLastHTMLResourceDPSUpload();

    /**
     *
     * @return last user to upload shared HTMLResources, null if not uploaded
     */
     String getLastHTMLResourceDPSUploadBy();
}
