/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.mobile.dps;

import java.util.HashMap;
import java.util.Map;

/**
 * Enum of DPS Importance
 *
 */
public enum Importance {
    LOW("low"),
    NORMAL("normal"),
    HIGH("high");

    /**
     * Enum map for lookup
     */
    private static Map<String, Importance> ENUM_BY_VALUE;

    /**
     * Used to map the property name to the enum value
     */
    static {
        ENUM_BY_VALUE = new HashMap<String, Importance>(Importance.values().length);
        for (Importance enumValue : Importance.values()) {
            ENUM_BY_VALUE.put(enumValue.getValue(), enumValue);
        }
    }

    /**
     * The value for this enum
     */
    private String value;

    /**
     * Create an Importance
     *
     * @param value The property value
     */
    private Importance(String value) {
        this.value = value;
    }

    /**
     * @return Importance value
     */
    public String getValue() {
        return value;
    }

    /**
     * Returns true if this is a Importance and false otherwise.
     *
     * @param value The value to check
     * @return true if a Importance and false otherwise
     */
    public static final boolean isImportance(String value) {
        return ENUM_BY_VALUE.containsKey(value);
    }

    /**
     * Return the Importance object for the specified value
     *
     * @param value used to specify the Importance
     * @return an Importance for the specified value or null if invalid
     */
    public static final Importance getImportance(String value) {
        return ENUM_BY_VALUE.get(value);
    }
}
