/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.mobile.dps;

import aQute.bnd.annotation.ProviderType;

/**
 * Media Constants
 *
 * @since CQ 5.6
 */
@ProviderType
public interface MediaConstants {

    // Media Image JCR Constants
    String PN_IS_SCALING_ENABLED = "scalingEnabled";
    String PN_IS_ORIGINAL_IMAGE_REQUESTED = "useOriginalImage";
    String PN_IMAGE_QUALITY = "quality";
    String PN_IMAGE_SCALE_WIDTH = "scalewidth";

    // Misc
    String DEFAULT_IMAGE_SELECTOR = ".img";

    // Image Qualities
    String IMAGE_QUALITY_SELECTOR_FULL = "full";
    String IMAGE_QUALITY_SELECTOR_HIGH = "full";
    String IMAGE_QUALITY_SELECTOR_MEDIUM = "full";
    String IMAGE_QUALITY_SELECTOR_LOW = "full";

    // Image widths
    String IMAGE_WIDTH_SELECTOR_FULL = "full";
    String IMAGE_WIDTH_SELECTOR_320  = "320"; // iPhone4 - portrait
    String IMAGE_WIDTH_SELECTOR_480  = "480"; // iPhone4 - landscape
    String IMAGE_WIDTH_SELECTOR_640  = "640"; // iPhone4/iphone5 - portrait
    String IMAGE_WIDTH_SELECTOR_960  = "960"; // iPhone4 - landscape
    String IMAGE_WIDTH_SELECTOR_1136 ="1136"; // iPhone5 - landscape
    String IMAGE_WIDTH_SELECTOR_768  = "768"; // iPad - portrait
    String IMAGE_WIDTH_SELECTOR_1024 = "1024";// iPad - landscape
    String IMAGE_WIDTH_SELECTOR_1536 = "1536";// iPad - portrait (X2)
    String IMAGE_WIDTH_SELECTOR_2048 = "2048";// iPad - landscape (X2)
}