package com.adobe.cq.mobile.dps.ui;


import com.adobe.cq.mobile.dps.DPSCollection;
import com.adobe.cq.mobile.dps.DPSException;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;

import java.util.Map;

public interface PublishDataSource {
    /**
     * Get articles from AEM and DPS.
     * @param searchCriteria Name/Value pairs used to filter the results.  Acceptable values are:
     *           - text: will search through string properties and see if the string contains the specified value
     *           - source: AEM or DPS will only extract entries from that source
     *        'searchCriteria' can be null.
     *
     *        Hint:  To get articles in a collection, get that collection and check its contentDetails property
     * @return
     * @throws DPSException
     */
    JSONObject getArticles(Map searchCriteria) throws DPSException;

    JSONObject getBanners(Map searchCriteria) throws DPSException;

    JSONObject getCollection(DPSCollection dpsCollection) throws DPSException;

    /**
     * Get collections from AEM and DPS.
     * @param searchCriteria
     *           - source:  AEM or DPS will only extract entries from that source
     *           - flatten: true or false.  If false, only return collections that are not contained in other collections.
     *        'searchCriteria' can be null.
     * @return
     * @throws DPSException
     */
    JSONObject getCollections(Map searchCriteria) throws DPSException;

    JSONObject getLayouts(Map searchCriteria) throws DPSException;

    Map<String, Object> convertJSONtoMap(JSONArray json) throws DPSException;
}
