/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.mobile.platform;

import com.day.cq.commons.LabeledResource;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;

import java.util.Set;

public interface MobileResource extends LabeledResource, Adaptable {

    /**
     * Returns the mobile resource properties.
     *
     * @return The mobile resource properties as a {@link org.apache.sling.api.resource.ValueMap}.
     */
    ValueMap getProperties();

    /**
     * Returns whether this mobile resource is of a specified app type. A type id from <code>MobileResourceConstants</code>
     * can be used.
     * @param types The list of mobile resource type ids. See {@link com.adobe.cq.mobile.platform.impl.MobileConstants} for common app types.
     * @return Whether this mobile resource is of a specified app type.
     */
    boolean isA(String... types);

    /**
     * Returns the mobile app types that have been added to this Resource.  A value of <code>null</code> will be
     * returned when this resource has no type.
     * @return The mobile types this resource has.
     */
    Set<String> getAppTypes();

    /**
     * Return the <code>MobileResourceType</code> that is associated with this <code>MobileResource</code>.
     *
     * @return the <code>MobileResourceType</code>, or null if the Resource does not support a MobileResourceType.
     * @see MobileResourceType
     * @deprecated This is deprecated because an app may have multiple types.
     */
    MobileResourceType getMobileResourceType();

    /**
     * Add the specified type id to this mobile resource.  A type id from <code>MobileResourceConstants</code> can be used or
     * any custom defined type id can be added as well.
     * @param type See {@link com.adobe.cq.mobile.platform.impl.MobileConstants} for common app types.
     * @return Whether the addition of the type was successful.
     */
    boolean addAppType(String type);
}
