/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.mobile.platform;

public enum MobileResourceType {

    /**
     * Enum to mark a group of application instances.  This application may have
     * many instances depending on language, locale, special event, etc.
     */
    GROUP("app-group"),

    /**
     * Enum to mark the an application instance.  This instance will eventually become one
     * mobile application.
     */
    INSTANCE("app-instance"),

    /**
     * Enum to mark the an content of an application instance.
     */
    CONTENT("app-content"),

    /**
     * Enum to mark the notifications of an application instance.
     */
    NOTIFICATION("app-notification");

    private String type;

    MobileResourceType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }
}
