/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.scheduled.exporter;

/**
 * The <code>ExportConfig</code> interface represents configurations managed by
 * the {@link ScheduledExporter} service.
 */
public interface ExportConfig {

    /**
     * The scheduler expression of this configuration.
     * 
     * @return Scheduler expression string
     */
    String getSchedulerExpression();

    /**
     * Returns the identification path of this configuration.
     * 
     * @return
     */
    String getPath();

    /**
     * Returns the type of this exporter. The type is a String representing the
     * {@link Exporter} implementation responsible for handling the export.
     * 
     * @return
     */
    String getType();

    /**
     * Returns the data source path. This is given to the {@link Exporter}
     * handling the {@link #getType()} of this configuration to acquire the
     * data.
     * 
     * @return
     */
    String getSource();

    /**
     * The enable state for the configuration.
     * 
     * @return <code>true</code> if enabled, <code>false</code> otherwise.
     */
    boolean isEnabled();

}
