/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.scheduled.exporter;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.scheduled.exporter.process.ExtractExportDataProcess;

/**
 * An <code>Exporter</code> is used to export data from the repository (normally
 * provided by {@link ExtractExportDataProcess}) to a specific location or
 * 3rd-party service.
 */
public interface Exporter {

    /**
     * Service name under which Exporter services are to be registered (value is
     * "com.adobe.cq.scheduled.exporter.Exporter").
     */
    static final String SERVICE_NAME = "com.adobe.cq.scheduled.exporter.Exporter";

    /**
     * The name of the service property defining the exporter type for the
     * exporter (value is "exporter.type").
     * <p>
     * This service property may be a single string value. The service is
     * registered for all types provided by this property.
     * <p>
     * If this service property is missing, empty or not one of the listed
     * types, the service cannot be used and is therefore ignored.
     */
    static final String TYPE_PROPERTY = "exporter.type";

    /**
     * This method is called to export data from the given <code>source</code>
     * resource.
     * 
     * @param config Configuration resource of this exporter
     * @param source {@link Resource} holding the data to export. If the
     *            resource does not exist or is not accessible the
     *            <code>source</code> is of type {@link NonExistingResource}
     * @throws ExportException may be thrown in case of problems accessing,
     *             transforming or actually exporting the data. If the failure
     *             is caused by an exception, this exception (
     *             <code>Throwable</code>) should be made available as the cause
     *             of this exception.
     */
    void exportData(Resource config, Resource source) throws ExportException;

}
