/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 * <p/>
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 * <p/>
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.screens.binding;

import org.apache.commons.collections.Predicate;

import com.adobe.cq.screens.device.Device;

/**
 * Defines the constants for devices
 */
public interface DeviceConstants {

    String DEVICE_TITLE = "title";
    String DEVICE_ID = "id";
    String DEVICE_PATH = "path";
    String DEVICE_DESCRIPTION = "description";
    String DEVICE_LAST_MODIFIED = "lastModified";
    String DEVICE_LAST_MODIFIED_BY = "lastModifiedBy";
    String DEVICE_MODEL = "model";
    String DEVICE_TYPE = "type";
    String DEVICE_VERSION = "version";
    String DEVICE_PLATFORM = "platform";
    String DEVICE_RESOLUTION = "resolution";
    String DEVICE_OFFSET_LEFT = "offsetLeft";
    String DEVICE_OFFSET_TOP = "offsetTop";
    String DEVICE_HEARTBEAT = "heartbeat";
    String DEVICE_SCREENSHOT = "screenshot";
    String DEVICE_LAST_SCREENSHOT = "lastScreenshot";
    String DEVICE_TIMESTAMP = "timestamp";
    String DEVICE_PROFILE_NAME = "profile_screens";
    String DEVICE_CONFIG_PATH = "configPath";
    String DEVICE_DISPLAY_PATH = "displayPath";

    /**
     * The type of the offline indicator. The indicator is shown when the player detects an offline situation and
     * cannot connect to the control or content server.
     *
     * possible values:
     * | `disabled` | No indicator is shown. This should be used as default for most production players |
     * | `spinner`  | Show AEM Screens spinner with milky overlay (default) |
     * | `minimal`  | Show little red pixel on the bottom right corner if link is down. |
     */
    String DEVICE_OFFLINE_INDICATOR = "offlineIndicator";

    /**
     * DeviceConfig Constants
     */
    String DEVICE_CONFIG_DEVICE_ID = "deviceId";
    String DEVICE_CONFIG_ZONE_MAPPING = "zoneMapping";
    String DEVICE_CONFIG_ZONE_TEMPLATE = "zoneTemplate";

    /**
     * Device iterator predicate that only includes devices assigned to a display.
     */
    Predicate PREDICATE_ASSIGNED = new Predicate() {
        @Override
        public boolean evaluate(Object o) {
            return ((Device) o).getDeviceConfig() != null;
        }
    };

    /**
     * Device iterator predicate that only includes devices that are not assigned to a display.
     */
    Predicate PREDICATE_NOT_ASSIGNED = new Predicate() {
        @Override
        public boolean evaluate(Object o) {
            return ((Device) o).getDeviceConfig() == null;
        }
    };
}
