/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.screens.binding;

public interface ScreensConstants {

    // Node types
    String RT_APPLICATION           = "screens/core/components/app";
    String RT_APPLICATION_CHANNEL   = "screens/core/components/appchannel";
    String RT_APPLICATION_FOLDER    = "screens/core/components/appfolder";
    String RT_CHANNEL               = "screens/core/components/channel";
    String RT_CHANNEL_FOLDER        = "screens/core/components/channelfolder";
    String RT_DEVICE                = "screens/core/components/device";
    String RT_DEVICE_FOLDER         = "screens/core/components/devicefolder";
    String RT_DEVICE_CONFIG         = "screens/core/components/deviceconfig";
    String RT_DISPLAY               = "screens/core/components/display";
    String RT_LOCATION              = "screens/core/components/location";
    String RT_LOCATION_FOLDER       = "screens/core/components/locationfolder";
    String RT_SCREEN                = "screens/core/components/screen";
    String RT_SEQUENCE_CHANNEL      = "screens/core/components/sequencechannel";
    String RT_PROJECT               = "screens/core/components/project";

    String TP_DEVICE_CONFIG       = "screens/core/templates/deviceconfig";

    // Node names
    String NN_CHANNELS  = "channels";
    String NN_IMAGE     = "image";
    String NN_MAP       = "map";

    // String node properties
    String PN_ACTIVE_CHANNEL        = "activeChannel";
    String PN_ADDRESS               = "address";
    String PN_BRAND                 = "brand";
    String PN_CSS_CLASS             = "cq:cssClass";
    String PN_CONDITIONS            = "conditions";
    String PN_DISPLAY               = "display";
    String PN_EVENTS                = "events";
    String PN_DIMENSIONS            = "dimensions";
    String PN_FEATURES              = "features";
    String PN_FORCE_REMOTE_CONTENT  = "forceRemoteContent";
    String PN_GEO_COORDINATES       = "geoCoordinates";
    String PN_HEIGHT                = "height";
    String PN_ID                    = "id";
    String PN_IDLE_TEXT             = "idleText";
    String PN_IDLE_TIMEOUT          = "idleTimeout";
    String PN_IDLE_TITLE            = "idleTitle";
    String PN_IMAGE_PIN_COORDINATES = "imagePinCoordinates";
    String PN_LAYOUT_NB_COLS        = "layoutNumCols";
    String PN_LAYOUT_NB_ROWS        = "layoutNumRows";
    String PN_MODEL                 = "model";
    String PN_PLATFORM              = "platform";
    String PN_UUID                  = "uuid";
    String PN_VERSION               = "version";
    String PN_OFFLINE               = "offline";
    String PN_OFFSET_LEFT           = "offsetLeft";
    String PN_OFFSET_TOP            = "offsetTop";
    String PN_PATH                  = "path";
    String PN_REL                   = "rel";
    String PN_RESOLUTION            = "resolution";
    String PN_ROLE                  = "role";
    String PN_SCHEDULE              = "schedule";
    String PN_SHOW_TOOLTIP          = "showTooltip";
    String PN_SVG_REFERENCE         = "svgReference";
    String PN_THUMBNAIL_PATH        = "thumbnailPath";
    String PN_TYPE                  = "type";
    String PN_WIDTH                 = "width";

    // String actions
    String ACT_ASSIGN_DEVICE            = "screens-dcc-actions-assigndevice-activator";
    String ACT_COPY                     = "screens-dcc-actions-copy-activator";
    String ACT_CREATE                   = "screens-dcc-actions-create-activator";
    String ACT_CREATE_STRUCTURE         = "screens-dcc-actions-createstructure-activator";
    String ACT_DELETE                   = "screens-dcc-actions-delete-activator";
    String ACT_EDIT                     = "screens-dcc-actions-edit-activator";
    String ACT_LINK_CHANNEL             = "screens-dcc-actions-assignchannel-activator";
    String ACT_MOVE                     = "screens-dcc-actions-move-activator";
    String ACT_REGISTER_DEVICE          = "screens-dcc-actions-register-activator";
    String ACT_UNASSIGN_DEVICE          = "screens-dcc-actions-unassigndevice-activator";
    String ACT_VIEW_CONTENT             = "screens-dcc-actions-preview-activator";
    String ACT_VIEW_DASHBOARD_CHANNEL   = "screens-dcc-actions-channelDashboard-activator";
    String ACT_VIEW_DASHBOARD_DISPLAY   = "screens-dcc-actions-displayDashboard-activator";
    String ACT_VIEW_DEVICE_MANAGER      = "screens-dcc-actions-deviceManager-activator";
    String ACT_VIEW_DISPLAY             = "screens-dcc-actions-display-activator";
    String ACT_VIEW_FOLDERPROPERTIES    = "screens-dcc-actions-folderproperties-activator";
    String ACT_VIEW_PROPERTIES          = "screens-dcc-actions-properties-activator";

}
