/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *   Copyright 2015 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.screens.device;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import aQute.bnd.annotation.ProviderType;

import org.apache.sling.api.adapter.Adaptable;

/**
 * Screens devices. Is adaptable to and from a resource, and to a value map to get its properties.
 */
@ProviderType
public interface Device extends Adaptable {

    /**
     * Returns the path of the device resource.
     * @return the path
     */
    @Nonnull
    String getPath();

    /**
     * Returns the id of the device.
     * @return the id
     */
    @Nonnull
    String getId();

    /**
     * Returns the device config or {@code null} if not assigned.
     * @return the config or {@code null}
     */
    @CheckForNull
    DeviceConfig getDeviceConfig();

}
