/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 * <p/>
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 * <p/>
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.screens.device;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.apache.sling.api.adapter.Adaptable;

/**
 * Screens device config. Is adaptable to and from a resource, and to a value map to get its properties.
 */
public interface DeviceConfig extends Adaptable {

    /**
     * Returns the path of the device config resource.
     * @return the path
     */
    @Nonnull
    String getPath();

    /**
     * Returns the path of the display.
     * @return the path
     */
    @Nonnull
    String getDisplayPath();

    /**
     * Returns the device id that is assigned to this config or {@code null} if not assigned.
     * @return the device id or {@code null}
     */
    @CheckForNull
    String getAssignedDeviceId();
}