/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.screens.device.registration;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.apache.sling.commons.json.JSONObject;

/**
 * Pending device object that is to be registered.
 */
public interface PendingDevice {

    /**
     * Retrieves the device token. This registration token is only used during registration and is not related to the final
     * device id, which is assigned once the device is registered.
     *
     * @return the device token
     */
    @Nonnull
    String getToken();

    /**
     * Returns the current registration state.
     * @return the state
     */
    @Nonnull
    State getState();

    /**
     * Returns the registration code that was sent by the device.
     * @return the registration code or {@code null} if the device isn't in registration mode yet.
     */
    @CheckForNull
    String getRegistrationCode();

    /**
     * Returns a json object that holds additional metadata which can be used to identify the device in the UI.
     * @return a metadata object
     */
    @Nonnull
    JSONObject getMetadata();

    /**
     * Returns the result of the registration process, once the device is registered.
     * @return the result or {@code null}
     */
    @CheckForNull
    RegistrationResult getRegistrationResult();

    /**
     * The current state of the registration process.
     */
    enum State {

        /**
         * The device is currently unregistered. The device sent its token and metadata information to the server.
         */
        UNREGISTERED,

        /**
         * The device is currently in the pre-registration phase and the sever waits for the code.
         */
        PREREGISTRATION,

        /**
         * The device is in the registration state. waiting for the user to complete the registration.
         */
        REGISTRATION,

        /**
         * The device is registered.
         */
        REGISTERED;

    }

}
