/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *   Copyright 2015 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.screens.device.registration;

import javax.annotation.Nonnull;

import aQute.bnd.annotation.ProviderType;

/**
 * Provides the result of the device registration process.
 */
@ProviderType
public interface RegistrationResult {

    /**
     * Returns the device id of the registered device.
     * @return the device id.
     */
    @Nonnull
    String getDeviceId();

    /**
     * Returns the path of the registered device.
     * @return the path.
     */
    @Nonnull
    String getDevicePath();

    /**
     * Returns the device user password of the registered device
     * @return the password.
     */
    @Nonnull
    String getPassword();

}
