/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.screens.device.registration;

import java.util.Iterator;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import aQute.bnd.annotation.ProviderType;

/**
 * Device registration service. This service is used to manage the registration requests from devices and manages the
 * registration process. It keeps an internal in-memory cache that holds the pending requests.
 */
@ProviderType
public interface RegistrationService {

    /**
     * Returns the temporary registration device with the given id or {@code null} if it does not exist.
     * @param token the device registration token
     * @return the device or {@code null}
     */
    @CheckForNull
    PendingDevice getDevice(@Nonnull String token);

    /**
     * Lists all registration devices that are in the given state.
     * @param state The state filter or {@code null}
     * @return An iterator over the devices.
     */
    @Nonnull
    Iterator<PendingDevice> getDevices(@Nullable PendingDevice.State state);

}
