/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/

package com.adobe.cq.screens.sessions;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;

import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.granite.socketio.SocketIOEmitter;

/**
 * {@code ScreenSession}...
 */
public interface ScreensSession {

    void setListener(ScreensSessionListener listener);

    void removeListener(ScreensSessionListener listener);

    Display getDisplay();

    SocketIOEmitter getEmitter();

    ResourceResolver getResourceResolver();

    ConcurrentMap<String, Object> getUserData();

    void broadcast() throws IOException;
}