/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.api;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @deprecated
 */
public class SearchUpdater implements EventListener {

    private static final Logger log =
        LoggerFactory.getLogger(SearchUpdater.class);

    private final SearchCollection collection;

    private NodeIndexerExtension indexerExtension;

    public SearchUpdater(SearchCollection collection) {
        this(collection, null);
    }

    public SearchUpdater(SearchCollection collection, NodeIndexerExtension indexerExtension) {
        super();
        this.collection = collection;
        this.indexerExtension = indexerExtension;
    }

    public void onEvent(EventIterator events) {
        Set<String> paths = new LinkedHashSet<String>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                if (eventRequiresReindex(event)) {
                    String path = event.getPath();
                    switch (event.getType()) {
                    case Event.NODE_ADDED:
                    case Event.NODE_REMOVED:
                        paths.add(path);
                        break;
                    case Event.NODE_MOVED:
                        Map<?, ?> info = event.getInfo();
                        if (info.containsKey("srcAbsPath")) {
                            paths.add(info.get("srcAbsPath").toString());
                        }
                        if (info.containsKey("destAbsPath")) {
                            paths.add(info.get("destAbsPath").toString());
                        }
                        break;
                    case Event.PROPERTY_ADDED:
                    case Event.PROPERTY_CHANGED:
                    case Event.PROPERTY_REMOVED:
                        int slash = path.lastIndexOf('/');
                        if (slash > 0) {
                            paths.add(path.substring(0, slash));
                        } else {
                            paths.add("/");
                        }
                        break;
                    }
                }
            } catch (RepositoryException e) {
                log.warn("Ignoring a broken observation event: " + event, e);
            }
        }
        if (paths.size() > 0){
            log.debug("collection.update call with {} paths", paths);
            collection.update(paths);
        }

    }

    private boolean eventRequiresReindex(final Event eventToCheck) {
        boolean requiresReindex;
        if (null == this.indexerExtension) {
            requiresReindex = true;
        } else {
            requiresReindex = this.indexerExtension.checkEventModifiesIndex(eventToCheck);
        }
        return requiresReindex;
    }

}
