/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

/**
 * The <code>DoubleField</code> class is a utility to convert double
 * values into <code>String</code> values that are lexicographically ordered
 * according to the double value.
 * 
 * @deprecated
 */
public class DoubleField {

    private static final long SIGN_MASK = 0x8000000000000000L;

    private static final int STRING_DOUBLE_LEN
            = Long.toString(Long.MAX_VALUE, Character.MAX_RADIX).length() + 1;

    private DoubleField() {
    }

    public static String doubleToString(double value) {
        long longValue = Double.doubleToLongBits(value);
        StringBuffer sb = new StringBuffer(STRING_DOUBLE_LEN);

        if ((longValue & SIGN_MASK) == 0) {
            // positive
            String s = Long.toString(longValue, Character.MAX_RADIX);
            // add sign character
            sb.append('1');
            while ((sb.length() + s.length()) < STRING_DOUBLE_LEN) {
                sb.append('0');
            }
            sb.append(s);
        } else {
            // negative
            // fold value by reversing sign
            longValue = -longValue;
            String s = Long.toString(longValue, Character.MAX_RADIX);
            // pad with leading zeros
            while ((sb.length() + s.length()) < STRING_DOUBLE_LEN) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static double stringToDouble(String value) {
        if (value.charAt(0) == '1') {
            // positive
            long longValue = Long.parseLong(value.substring(1), Character.MAX_RADIX);
            return Double.longBitsToDouble(longValue);
        } else if (value.charAt(0) == '0') {
            // negative
            long longValue = Long.parseLong(value, Character.MAX_RADIX);
            // switch sign
            longValue = -longValue;
            return Double.longBitsToDouble(longValue);
        } else {
            throw new IllegalArgumentException("not a valid string representation of a double: " + value);
        }
    }
}
