/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

/**
 * @deprecated
 */
public class JCRDirectory extends Directory {

    private final Node directory;

    public JCRDirectory(Node directory) {
        this.directory = directory;
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        try {
            List<String> names = new ArrayList<String>();
            for (Node file : JcrUtils.getChildNodes(directory)) {
                names.add(file.getName());
            }
            return names.toArray(new String[names.size()]);
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    @Override
    public synchronized boolean fileExists(String name) throws IOException {
        try {
            return directory.hasNode(name);
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    @Override
    public synchronized long fileModified(String name) throws IOException {
        try {
            Node file = directory.getNode(name);
            Node content = file.getNode(Property.JCR_CONTENT);
            return content.getProperty(Property.JCR_LAST_MODIFIED).getLong();
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    @Override
    public synchronized void touchFile(String name) throws IOException {
        try {
            Node file = directory.getNode(name);
            Node content = file.getNode(Property.JCR_CONTENT);
            content.setProperty(Property.JCR_LAST_MODIFIED,
                    System.currentTimeMillis());
            directory.getSession().save();
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    @Override
    public synchronized void deleteFile(String name) throws IOException {
        try {
            directory.getNode(name).remove();
            directory.getSession().save();
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    @Override
    public synchronized long fileLength(String name) throws IOException {
        try {
            Node file = directory.getNode(name);
            Node content = file.getNode(Property.JCR_CONTENT);
            return content.getProperty(Property.JCR_DATA).getLength();
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    @Override
    public synchronized IndexInput openInput(String name) throws IOException {
        byte[] data = readFile(name);
        if (data != null) {
            return new JCRIndexInput(data, name);
        } else {
            throw new IOException();
        }
    }

    @Override
    public synchronized IndexOutput createOutput(String name)
            throws IOException {
        // create empty node first
        writeFile(name, new byte[] {});
        return new JCRIndexOutput(this, name);
    }

    @Override
    public void close() throws IOException {
    }

    synchronized byte[] readFile(String name) throws IOException {
        try {
            Node file = directory.getNode(name);
            Node content = file.getNode(Property.JCR_CONTENT);
            Binary binary = content.getProperty(Property.JCR_DATA).getBinary();
            try {
                InputStream stream = binary.getStream();
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    IOUtils.copy(stream, buffer);
                    return buffer.toByteArray();
                } finally {
                    stream.close();
                }
            } finally {
                binary.dispose();
            }
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    synchronized void writeFile(String name, byte[] data) throws IOException {
        try {
            JcrUtils.putFile(directory, name, "application/octet-stream",
                    new ByteArrayInputStream(data));
            directory.getSession().save();
        } catch (RepositoryException e) {
            throw new IOExceptionWithCause(e);
        }
    }

}
