/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

import java.io.IOException;

import org.apache.lucene.store.IndexInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @deprecated
 */
class JCRIndexInput extends IndexInput {
    private Logger log = LoggerFactory.getLogger(getClass());
    private final byte[] data;

    private int position = 0;

    public JCRIndexInput(byte[] data, String name) throws IOException {
        super(name);
        this.data = data;
    }

    @Override
    public byte readByte() throws IOException {
        if (position < data.length) {
            return data[position++];
        } else {
            throw new IOException();
        }
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (data.length == 0 && offset == 0 && len == 0) {
            return;
        }
        if (position + len <= data.length) {
            System.arraycopy(data, position, b, offset, len);
            position += len;
        } else {
            throw new IOException("real len " + data.length + ", req: "
                    + position + "/" + len);
        }
    }

    @Override
    public long getFilePointer() {
        return position;
    }

    @Override
    public void seek(long pos) throws IOException {
        log.debug("seek {} {}", pos, data.length);
        //NOTE: seek() may be called with pos == data.length
        //This is similar to this issue: https://issues.apache.org/jira/browse/LUCENE-1196
        //Note that if readByte(s) is executed when position = data.length,
        //there is a separate check for EOF there.
        if (0 <= pos && pos <= data.length) {
            position = (int) pos;
        } else {
            throw new IOException();
        }
    }

    @Override
    public long length() {
        return data.length;
    }

    @Override
    public void close() throws IOException {
    }

}
